/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import net.java.dev.designgridlayout.AbstractRow;
import net.java.dev.designgridlayout.BarRow;
import net.java.dev.designgridlayout.CenterRow;
import net.java.dev.designgridlayout.DefaultGrowPolicy;
import net.java.dev.designgridlayout.DesignGridLayoutManager;
import net.java.dev.designgridlayout.GridRow;
import net.java.dev.designgridlayout.HeightGrowPolicy;
import net.java.dev.designgridlayout.IBarRow;
import net.java.dev.designgridlayout.IGridRow;
import net.java.dev.designgridlayout.INonGridRow;
import net.java.dev.designgridlayout.IRowCreator;
import net.java.dev.designgridlayout.ISpannableGridRow;
import net.java.dev.designgridlayout.LabelAlignment;
import net.java.dev.designgridlayout.LeftRow;
import net.java.dev.designgridlayout.OrientationPolicy;
import net.java.dev.designgridlayout.RightRow;
import net.java.dev.designgridlayout.RowGroup;
import net.java.dev.designgridlayout.UnitHeightGrowPolicy;

public class DesignGridLayout {
    private static HeightGrowPolicy _defaultHeightTester = new DefaultGrowPolicy();
    private final DesignGridLayoutManager _layout;
    private final Container _parent;
    private final OrientationPolicy _orientation;
    private final List<AbstractRow> _rows = new ArrayList<AbstractRow>();
    private AbstractRow _current = null;
    private HeightGrowPolicy _heightTester = _defaultHeightTester;

    public DesignGridLayout(Container parent) {
        if (parent == null) {
            throw new NullPointerException("parent cannot be null");
        }
        this._orientation = new OrientationPolicy(parent);
        this._layout = new DesignGridLayoutManager(this, parent, this._rows, this._orientation);
        this._layout.setHeightTester(this._heightTester);
        this._parent = parent;
        this._parent.setLayout(this._layout);
    }

    public DesignGridLayout margins(double top, double left, double bottom, double right) {
        this._layout.setMargins(top, left, bottom, right);
        return this;
    }

    public DesignGridLayout margins(double ratio) {
        return this.margins(ratio, ratio, ratio, ratio);
    }

    public DesignGridLayout forceConsistentBaselinesDistance() {
        this._layout.setForceConsistentBaselinesDistance(true);
        return this;
    }

    public DesignGridLayout disableSmartVerticalResize() {
        if (!(this._heightTester instanceof UnitHeightGrowPolicy)) {
            this._heightTester = new UnitHeightGrowPolicy(this._heightTester);
        }
        this._layout.setHeightTester(this._heightTester);
        return this;
    }

    public DesignGridLayout labelAlignment(LabelAlignment align) {
        if (align != null) {
            this._layout.labelAlignment(align);
        }
        return this;
    }

    public DesignGridLayout withoutConsistentWidthAcrossNonGridRows() {
        this._layout.setConsistentWidthInNonGridRows(false);
        return this;
    }

    public IRowCreator row() {
        return new RowCreator(-1.0);
    }

    public IRowCreator row(double verticalWeight) {
        return new RowCreator(verticalWeight);
    }

    public void emptyRow() {
        if (this._current != null) {
            this._current.setUnrelatedGap();
        }
    }

    private <T extends AbstractRow> T addRow(T row, double verticalWeight, List<RowGroup> groups) {
        this._current = row;
        this._rows.add(row);
        row.init(this._parent, this._heightTester, this._orientation);
        row.growWeight(verticalWeight);
        for (RowGroup group2 : groups) {
            group2.add(row);
        }
        return row;
    }

    private class RowCreator
    implements IRowCreator {
        private final double _weight;
        private final List<RowGroup> _groups = new ArrayList<RowGroup>();

        RowCreator(double weight) {
            this._weight = weight;
        }

        @Override
        public IRowCreator group(RowGroup group2) {
            this._groups.add(group2);
            return this;
        }

        @Override
        public INonGridRow center() {
            return (INonGridRow)((Object)DesignGridLayout.this.addRow(new CenterRow(), this._weight, this._groups));
        }

        @Override
        public INonGridRow left() {
            return (INonGridRow)((Object)DesignGridLayout.this.addRow(new LeftRow(), this._weight, this._groups));
        }

        @Override
        public INonGridRow right() {
            return (INonGridRow)((Object)DesignGridLayout.this.addRow(new RightRow(), this._weight, this._groups));
        }

        @Override
        public IBarRow bar() {
            return (IBarRow)((Object)DesignGridLayout.this.addRow(new BarRow(), this._weight, this._groups));
        }

        @Override
        public ISpannableGridRow grid(JLabel label) {
            return ((GridRow)DesignGridLayout.this.addRow(this.newGridRow(), this._weight, this._groups)).grid(label);
        }

        @Override
        public IGridRow grid(JLabel label, int gridspan) {
            return ((GridRow)DesignGridLayout.this.addRow(this.newGridRow(), this._weight, this._groups)).grid(label, gridspan);
        }

        @Override
        public ISpannableGridRow grid() {
            return ((GridRow)DesignGridLayout.this.addRow(this.newGridRow(), this._weight, this._groups)).grid();
        }

        @Override
        public IGridRow grid(int gridspan) {
            return ((GridRow)DesignGridLayout.this.addRow(this.newGridRow(), this._weight, this._groups)).grid(gridspan);
        }

        private GridRow newGridRow() {
            AbstractRow previous;
            if (!DesignGridLayout.this._rows.isEmpty() && (previous = (AbstractRow)DesignGridLayout.this._rows.get(DesignGridLayout.this._rows.size() - 1)) instanceof GridRow) {
                return new GridRow((GridRow)previous);
            }
            return new GridRow(null);
        }
    }
}

